/*
 * Decompiled with CFR 0.152.
 */
package com.ms.studio.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import run.halo.app.infra.utils.JsonUtils;

public class PatchUtils {
    private static final String DELIMITER = "\n";
    private static final Splitter lineSplitter = Splitter.on((String)"\n");

    public static Patch<String> create(String deltasJson) {
        List deltas = (List)JsonUtils.jsonToObject((String)deltasJson, (TypeReference)new TypeReference<List<Delta>>(){});
        Patch patch = new Patch();
        block5: for (Delta delta : deltas) {
            StringChunk sourceChunk = delta.getSource();
            StringChunk targetChunk = delta.getTarget();
            Chunk orgChunk = new Chunk(sourceChunk.getPosition(), sourceChunk.getLines(), sourceChunk.getChangePosition());
            Chunk revChunk = new Chunk(targetChunk.getPosition(), targetChunk.getLines(), targetChunk.getChangePosition());
            switch (delta.getType()) {
                case DELETE: {
                    patch.addDelta((AbstractDelta)new DeleteDelta(orgChunk, revChunk));
                    continue block5;
                }
                case INSERT: {
                    patch.addDelta((AbstractDelta)new InsertDelta(orgChunk, revChunk));
                    continue block5;
                }
                case CHANGE: {
                    patch.addDelta((AbstractDelta)new ChangeDelta(orgChunk, revChunk));
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unsupported delta type.");
        }
        return patch;
    }

    public static String patchToJson(Patch<String> patch) {
        List deltas = patch.getDeltas();
        return JsonUtils.objectToJson((Object)deltas);
    }

    public static String applyPatch(String original, String patchJson) {
        Patch<String> patch = PatchUtils.create(patchJson);
        try {
            return String.join((CharSequence)DELIMITER, patch.applyTo(PatchUtils.breakLine(original)));
        }
        catch (PatchFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String diffToJsonPatch(String original, String revised) {
        Patch patch = DiffUtils.diff(PatchUtils.breakLine(original), PatchUtils.breakLine(revised));
        return PatchUtils.patchToJson((Patch<String>)patch);
    }

    public static List<String> breakLine(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.emptyList();
        }
        return lineSplitter.splitToList((CharSequence)content);
    }

    public static class Delta {
        private StringChunk source;
        private StringChunk target;
        private DeltaType type;

        public StringChunk getSource() {
            return this.source;
        }

        public StringChunk getTarget() {
            return this.target;
        }

        public DeltaType getType() {
            return this.type;
        }

        public void setSource(StringChunk source) {
            this.source = source;
        }

        public void setTarget(StringChunk target) {
            this.target = target;
        }

        public void setType(DeltaType type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Delta)) {
                return false;
            }
            Delta other = (Delta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StringChunk this$source = this.getSource();
            StringChunk other$source = other.getSource();
            if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
                return false;
            }
            StringChunk this$target = this.getTarget();
            StringChunk other$target = other.getTarget();
            if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
                return false;
            }
            DeltaType this$type = this.getType();
            DeltaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Delta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StringChunk $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
            StringChunk $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
            DeltaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "PatchUtils.Delta(source=" + this.getSource() + ", target=" + this.getTarget() + ", type=" + this.getType() + ")";
        }
    }

    public static class StringChunk {
        private int position;
        private List<String> lines;
        private List<Integer> changePosition;

        public int getPosition() {
            return this.position;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public List<Integer> getChangePosition() {
            return this.changePosition;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public void setLines(List<String> lines) {
            this.lines = lines;
        }

        public void setChangePosition(List<Integer> changePosition) {
            this.changePosition = changePosition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringChunk)) {
                return false;
            }
            StringChunk other = (StringChunk)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPosition() != other.getPosition()) {
                return false;
            }
            List<String> this$lines = this.getLines();
            List<String> other$lines = other.getLines();
            if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
                return false;
            }
            List<Integer> this$changePosition = this.getChangePosition();
            List<Integer> other$changePosition = other.getChangePosition();
            return !(this$changePosition == null ? other$changePosition != null : !((Object)this$changePosition).equals(other$changePosition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StringChunk;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPosition();
            List<String> $lines = this.getLines();
            result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
            List<Integer> $changePosition = this.getChangePosition();
            result = result * 59 + ($changePosition == null ? 43 : ((Object)$changePosition).hashCode());
            return result;
        }

        public String toString() {
            return "PatchUtils.StringChunk(position=" + this.getPosition() + ", lines=" + this.getLines() + ", changePosition=" + this.getChangePosition() + ")";
        }
    }
}

